#include <bits/stdc++.h>

#define ll long long

void knapsack(ll W, std::vector<ll>& w, std::vector<ll>& v, double sf)
{
    std::vector<std::vector<ll>> dp(w.size() + 1, std::vector<ll>(5000 + 1, 1LL << 60));
    dp[0][0] = 0;

    for(ll i = 0; i < w.size(); i++)
    {
        for(ll j = 0; j < 5001; j++)
        {
            if(j - v[i] >= 0)
                dp[i + 1][j] = std::min(dp[i + 1][j], dp[i][j - v[i]] + w[i]);
            
            dp[i + 1][j] = std::min(dp[i + 1][j], dp[i][j]);
        }
    }

    ll res = 0;
    for(int i = 0; i < 3001; i++)
        if(dp[w.size()][i] <= W)
            res = i;
    
    ll r = res;
    std::vector<ll> items;

    for(ll i = w.size(); i > 0 && r > 0; i--)
    {
        if(dp[w.size()][r] == dp[i][res])
            continue;
        else
        {
            items.push_back(i + 1);
            r -= i;
        }
    }

    std::sort(items.begin(), items.end());
    std::cout << items.size() << "\n";
    for(const ll& x : items)
        std::cout << x << " ";
}

int main()
{
    ll N, W;
    double ep;
    std::cin >> N >> W >> ep;
    
    std::vector<ll> w(N), v(N);
    for(ll i = 0; i < N; i++)
        std::cin >> w[i] >> v[i];

    ll t = 0;
    double sf = ((1 - ep) * (*std::max_element(v.begin(), v.end()))) / N;
    for(ll i = 0; i < N; i++)
    {
        v[i] = floor((double)v[i] / sf);
        t += v[i];
    }

    knapsack(t, w, v, sf);

    return 0;
}